import * as cp from 'child_process';
import ChildProcess = cp.ChildProcess;
import { TextDocument, Disposable, FileSystemWatcher, CancellationToken } from 'vscode';
import { Message, RequestHandler, NotificationHandler, RequestType, NotificationType, Trace, Event } from 'vscode-jsonrpc';
import { Position, Range, Location, TextDocumentIdentifier, TextDocumentPositionParams, TextEdit, TextEditChange, WorkspaceChange, FileEvent } from './protocol';
import * as c2p from './codeConverter';
import * as p2c from './protocolConverter';
export { RequestType, NotificationType, NotificationHandler, Position, Range, Location, TextDocumentIdentifier, TextDocumentPositionParams, TextEdit, TextEditChange, WorkspaceChange, c2p as Code2Protocol, p2c as Protocol2Code };
export interface StreamInfo {
    writer: NodeJS.WritableStream;
    reader: NodeJS.ReadableStream;
}
export interface ExecutableOptions {
    cwd?: string;
    stdio?: string | string[];
    env?: any;
    detached?: boolean;
}
export interface Executable {
    command: string;
    args?: string[];
    options?: ExecutableOptions;
}
export interface ForkOptions {
    cwd?: string;
    env?: any;
    encoding?: string;
    execArgv?: string[];
}
export declare enum TransportKind {
    stdio = 0,
    ipc = 1,
}
export interface NodeModule {
    module: string;
    transport?: TransportKind;
    args?: string[];
    runtime?: string;
    options?: ForkOptions;
}
export declare type ServerOptions = Executable | {
    run: Executable;
    debug: Executable;
} | {
    run: NodeModule;
    debug: NodeModule;
} | NodeModule | (() => Thenable<ChildProcess | StreamInfo>);
/**
 * An action to be performed when the connection is producing errors.
 */
export declare enum ErrorAction {
    /**
     * Continue running the server.
     */
    Continue = 1,
    /**
     * Shutdown the server.
     */
    Shutdown = 2,
}
/**
 * An action to be performed when the connection to a server got closed.
 */
export declare enum CloseAction {
    /**
     * Don't restart the server. The connection stays closed.
     */
    DoNotRestart = 1,
    /**
     * Restart the server.
     */
    Restart = 2,
}
/**
 * A pluggable error handler that is invoked when the connection is either
 * producing errors or got closed.
 */
export interface ErrorHandler {
    /**
     * An error has occurred while writing or reading from the connection.
     *
     * @param error - the error received
     * @param message - the message to be delivered to the server if know.
     * @param count - a count indicating how often an error is received. Will
     *  be reset if a message got successfully send or received.
     */
    error(error: Error, message: Message, count: number): ErrorAction;
    /**
     * The connection to the server got closed.
     */
    closed(): CloseAction;
}
export interface SynchronizeOptions {
    configurationSection?: string | string[];
    fileEvents?: FileSystemWatcher | FileSystemWatcher[];
    textDocumentFilter?: (textDocument: TextDocument) => boolean;
}
export interface LanguageClientOptions {
    documentSelector?: string | string[];
    synchronize?: SynchronizeOptions;
    diagnosticCollectionName?: string;
    initializationOptions?: any;
    errorHandler?: ErrorHandler;
}
export declare class LanguageClient {
    private _name;
    private _serverOptions;
    private _languageOptions;
    private _forceDebug;
    private _state;
    private _onReady;
    private _onReadyCallbacks;
    private _connection;
    private _childProcess;
    private _outputChannel;
    private _capabilites;
    private _listeners;
    private _providers;
    private _diagnostics;
    private _syncExpression;
    private _documentSyncDelayer;
    private _fileEvents;
    private _fileEventDelayer;
    private _telemetryEmitter;
    private _trace;
    private _tracer;
    constructor(name: string, serverOptions: ServerOptions, languageOptions: LanguageClientOptions, forceDebug?: boolean);
    private computeSyncExpression();
    sendRequest<P, R, E>(type: RequestType<P, R, E>, params: P, token?: CancellationToken): Thenable<R>;
    private doSendRequest<P, R, E>(connection, type, params, token?);
    sendNotification<P>(type: NotificationType<P>, params?: P): void;
    onNotification<P>(type: NotificationType<P>, handler: NotificationHandler<P>): void;
    onRequest<P, R, E>(type: RequestType<P, R, E>, handler: RequestHandler<P, R, E>): void;
    onTelemetry: Event<any>;
    private outputChannel;
    trace: Trace;
    private logTrace(message);
    needsStart(): boolean;
    needsStop(): boolean;
    onReady(): Promise<void>;
    private isConnectionActive();
    start(): Disposable;
    private resolveConnection();
    private initialize(connection);
    stop(): void;
    private cleanUp(diagnostics?);
    notifyConfigurationChanged(settings: any): void;
    notifyFileEvent(event: FileEvent): void;
    private onDidOpenTextDoument(connection, textDocument);
    private onDidChangeTextDocument(connection, event);
    private onDidCloseTextDoument(connection, textDocument);
    private onDidSaveTextDocument(conneciton, textDocument);
    private forceDocumentSync();
    private handleDiagnostics(params);
    private createConnection();
    private handleConnectionClosed();
    private handleConnectionError(error, message, count);
    private checkProcessDied(childProcess);
    private hookConfigurationChanged(connection);
    private onDidChangeConfiguration(connection);
    private extractSettingsInformation(keys);
    private hookFileEvents(connection);
    private hookCapabilities(connection);
    private hookCompletionProvider(documentSelector, connection);
    private hookHoverProvider(documentSelector, connection);
    private hookSignatureHelpProvider(documentSelector, connection);
    private hookDefinitionProvider(documentSelector, connection);
    private hookReferencesProvider(documentSelector, connection);
    private hookDocumentHighlightProvider(documentSelector, connection);
    private hookDocumentSymbolProvider(documentSelector, connection);
    private hookWorkspaceSymbolProvider(connection);
    private hookCodeActionsProvider(documentSelector, connection);
    private hookCodeLensProvider(documentSelector, connection);
    private hookDocumentFormattingProvider(documentSelector, connection);
    private hookDocumentRangeFormattingProvider(documentSelector, connection);
    private hookDocumentOnTypeFormattingProvider(documentSelector, connection);
    private hookRenameProvider(documentSelector, connection);
}
export declare class SettingMonitor {
    private _client;
    private _setting;
    private _listeners;
    constructor(_client: LanguageClient, _setting: string);
    start(): Disposable;
    private onDidChangeConfiguration();
}
