import * as code from 'vscode';
import * as proto from './protocol';
export declare function asTextDocumentIdentifier(textDocument: code.TextDocument): proto.TextDocumentIdentifier;
export declare function asOpenTextDocumentParams(textDocument: code.TextDocument): proto.DidOpenTextDocumentParams;
export declare function asChangeTextDocumentParams(textDocument: code.TextDocument): proto.DidChangeTextDocumentParams;
export declare function asChangeTextDocumentParams(event: code.TextDocumentChangeEvent): proto.DidChangeTextDocumentParams;
export declare function asCloseTextDocumentParams(textDocument: code.TextDocument): proto.DidCloseTextDocumentParams;
export declare function asSaveTextDocumentParams(textDocument: code.TextDocument): proto.DidSaveTextDocumentParams;
export declare function asTextDocumentPositionParams(textDocument: code.TextDocument, position: code.Position): proto.TextDocumentPositionParams;
export declare function asWorkerPosition(position: code.Position): proto.Position;
export declare function asRange(value: code.Range): proto.Range;
export declare function asPosition(value: code.Position): proto.Position;
export declare function asDiagnosticSeverity(value: code.DiagnosticSeverity): proto.DiagnosticSeverity;
export declare function asDiagnostic(item: code.Diagnostic): proto.Diagnostic;
export declare function asDiagnostics(items: code.Diagnostic[]): proto.Diagnostic[];
export declare function asCompletionItem(item: code.CompletionItem): proto.CompletionItem;
export declare function asTextEdit(edit: code.TextEdit): proto.TextEdit;
export declare function asReferenceParams(textDocument: code.TextDocument, position: code.Position, options: {
    includeDeclaration: boolean;
}): proto.ReferenceParams;
export declare function asCodeActionContext(context: code.CodeActionContext): proto.CodeActionContext;
export declare function asCommand(item: code.Command): proto.Command;
export declare function asCodeLens(item: code.CodeLens): proto.CodeLens;
export declare function asFormattingOptions(item: code.FormattingOptions): proto.FormattingOptions;
export declare function asDocumentSymbolParams(textDocument: code.TextDocument): proto.DocumentSymbolParams;
export declare function asCodeLensParams(textDocument: code.TextDocument): proto.CodeLensParams;
