var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Contracts;
(function (Contracts) {
    (function (DataPointType) {
        DataPointType[DataPointType["Measurement"] = 0] = "Measurement";
        DataPointType[DataPointType["Aggregation"] = 1] = "Aggregation";
    })(Contracts.DataPointType || (Contracts.DataPointType = {}));
    var DataPointType = Contracts.DataPointType;
    (function (DependencyKind) {
        DependencyKind[DependencyKind["SQL"] = 0] = "SQL";
        DependencyKind[DependencyKind["Http"] = 1] = "Http";
        DependencyKind[DependencyKind["Other"] = 2] = "Other";
    })(Contracts.DependencyKind || (Contracts.DependencyKind = {}));
    var DependencyKind = Contracts.DependencyKind;
    (function (DependencySourceType) {
        DependencySourceType[DependencySourceType["Undefined"] = 0] = "Undefined";
        DependencySourceType[DependencySourceType["Aic"] = 1] = "Aic";
        DependencySourceType[DependencySourceType["Apmc"] = 2] = "Apmc";
    })(Contracts.DependencySourceType || (Contracts.DependencySourceType = {}));
    var DependencySourceType = Contracts.DependencySourceType;
    (function (SessionState) {
        SessionState[SessionState["Start"] = 0] = "Start";
        SessionState[SessionState["End"] = 1] = "End";
    })(Contracts.SessionState || (Contracts.SessionState = {}));
    var SessionState = Contracts.SessionState;
    (function (SeverityLevel) {
        SeverityLevel[SeverityLevel["Verbose"] = 0] = "Verbose";
        SeverityLevel[SeverityLevel["Information"] = 1] = "Information";
        SeverityLevel[SeverityLevel["Warning"] = 2] = "Warning";
        SeverityLevel[SeverityLevel["Error"] = 3] = "Error";
        SeverityLevel[SeverityLevel["Critical"] = 4] = "Critical";
    })(Contracts.SeverityLevel || (Contracts.SeverityLevel = {}));
    var SeverityLevel = Contracts.SeverityLevel;
    var ContextTagKeys = (function () {
        function ContextTagKeys() {
            this.applicationVersion = "ai.application.ver";
            this.applicationBuild = "ai.application.build";
            this.deviceId = "ai.device.id";
            this.deviceIp = "ai.device.ip";
            this.deviceLanguage = "ai.device.language";
            this.deviceLocale = "ai.device.locale";
            this.deviceModel = "ai.device.model";
            this.deviceNetwork = "ai.device.network";
            this.deviceOEMName = "ai.device.oemName";
            this.deviceOS = "ai.device.os";
            this.deviceOSVersion = "ai.device.osVersion";
            this.deviceRoleInstance = "ai.device.roleInstance";
            this.deviceRoleName = "ai.device.roleName";
            this.deviceScreenResolution = "ai.device.screenResolution";
            this.deviceType = "ai.device.type";
            this.deviceMachineName = "ai.device.machineName";
            this.locationIp = "ai.location.ip";
            this.operationId = "ai.operation.id";
            this.operationName = "ai.operation.name";
            this.operationParentId = "ai.operation.parentId";
            this.operationRootId = "ai.operation.rootId";
            this.operationSyntheticSource = "ai.operation.syntheticSource";
            this.operationIsSynthetic = "ai.operation.isSynthetic";
            this.sessionId = "ai.session.id";
            this.sessionIsFirst = "ai.session.isFirst";
            this.sessionIsNew = "ai.session.isNew";
            this.userAccountAcquisitionDate = "ai.user.accountAcquisitionDate";
            this.userAccountId = "ai.user.accountId";
            this.userAgent = "ai.user.userAgent";
            this.userId = "ai.user.id";
            this.userStoreRegion = "ai.user.storeRegion";
            this.sampleRate = "ai.sample.sampleRate";
            this.internalSdkVersion = "ai.internal.sdkVersion";
            this.internalAgentVersion = "ai.internal.agentVersion";
        }
        return ContextTagKeys;
    })();
    Contracts.ContextTagKeys = ContextTagKeys;
    var Domain = (function () {
        function Domain() {
        }
        return Domain;
    })();
    Contracts.Domain = Domain;
    var Data = (function () {
        function Data() {
        }
        return Data;
    })();
    Contracts.Data = Data;
    var Envelope = (function () {
        function Envelope() {
            this.ver = 1;
            this.sampleRate = 100.0;
            this.tags = {};
        }
        return Envelope;
    })();
    Contracts.Envelope = Envelope;
    var EventData = (function (_super) {
        __extends(EventData, _super);
        function EventData() {
            this.ver = 2;
            this.properties = {};
            this.measurements = {};
            _super.call(this);
        }
        return EventData;
    })(Contracts.Domain);
    Contracts.EventData = EventData;
    var MessageData = (function (_super) {
        __extends(MessageData, _super);
        function MessageData() {
            this.ver = 2;
            this.properties = {};
            _super.call(this);
        }
        return MessageData;
    })(Contracts.Domain);
    Contracts.MessageData = MessageData;
    var ExceptionData = (function (_super) {
        __extends(ExceptionData, _super);
        function ExceptionData() {
            this.ver = 2;
            this.exceptions = [];
            this.properties = {};
            this.measurements = {};
            _super.call(this);
        }
        return ExceptionData;
    })(Contracts.Domain);
    Contracts.ExceptionData = ExceptionData;
    var StackFrame = (function () {
        function StackFrame() {
        }
        return StackFrame;
    })();
    Contracts.StackFrame = StackFrame;
    var ExceptionDetails = (function () {
        function ExceptionDetails() {
            this.hasFullStack = true;
            this.parsedStack = [];
        }
        return ExceptionDetails;
    })();
    Contracts.ExceptionDetails = ExceptionDetails;
    var DataPoint = (function () {
        function DataPoint() {
            this.kind = Contracts.DataPointType.Measurement;
        }
        return DataPoint;
    })();
    Contracts.DataPoint = DataPoint;
    var MetricData = (function (_super) {
        __extends(MetricData, _super);
        function MetricData() {
            this.ver = 2;
            this.metrics = [];
            this.properties = {};
            _super.call(this);
        }
        return MetricData;
    })(Contracts.Domain);
    Contracts.MetricData = MetricData;
    var PageViewData = (function (_super) {
        __extends(PageViewData, _super);
        function PageViewData() {
            this.ver = 2;
            this.properties = {};
            this.measurements = {};
            _super.call(this);
        }
        return PageViewData;
    })(Contracts.EventData);
    Contracts.PageViewData = PageViewData;
    var PageViewPerfData = (function (_super) {
        __extends(PageViewPerfData, _super);
        function PageViewPerfData() {
            this.ver = 2;
            this.properties = {};
            this.measurements = {};
            _super.call(this);
        }
        return PageViewPerfData;
    })(Contracts.PageViewData);
    Contracts.PageViewPerfData = PageViewPerfData;
    var RemoteDependencyData = (function (_super) {
        __extends(RemoteDependencyData, _super);
        function RemoteDependencyData() {
            this.ver = 2;
            this.kind = Contracts.DataPointType.Measurement;
            this.dependencyKind = Contracts.DependencyKind.Other;
            this.success = true;
            this.dependencySource = Contracts.DependencySourceType.Undefined;
            this.properties = {};
            _super.call(this);
        }
        return RemoteDependencyData;
    })(Contracts.Domain);
    Contracts.RemoteDependencyData = RemoteDependencyData;
    var AjaxCallData = (function (_super) {
        __extends(AjaxCallData, _super);
        function AjaxCallData() {
            this.ver = 2;
            this.properties = {};
            this.measurements = {};
            _super.call(this);
        }
        return AjaxCallData;
    })(Contracts.PageViewData);
    Contracts.AjaxCallData = AjaxCallData;
    var RequestData = (function (_super) {
        __extends(RequestData, _super);
        function RequestData() {
            this.ver = 2;
            this.properties = {};
            this.measurements = {};
            _super.call(this);
        }
        return RequestData;
    })(Contracts.Domain);
    Contracts.RequestData = RequestData;
    var SessionStateData = (function (_super) {
        __extends(SessionStateData, _super);
        function SessionStateData() {
            this.ver = 2;
            this.state = Contracts.SessionState.Start;
            _super.call(this);
        }
        return SessionStateData;
    })(Contracts.Domain);
    Contracts.SessionStateData = SessionStateData;
    var PerformanceCounterData = (function (_super) {
        __extends(PerformanceCounterData, _super);
        function PerformanceCounterData() {
            this.ver = 2;
            this.kind = DataPointType.Aggregation;
            this.properties = {};
            _super.call(this);
        }
        return PerformanceCounterData;
    })(Contracts.Domain);
    Contracts.PerformanceCounterData = PerformanceCounterData;
})(Contracts = exports.Contracts || (exports.Contracts = {}));
