import { ChildProcess } from 'child_process';
import { Message } from './messages';
import { Event } from './events';
export interface MessageWriter {
    onError: Event<[Error, Message, number]>;
    onClose: Event<void>;
    write(msg: Message): void;
}
export declare abstract class AbstractMessageWriter {
    private errorEmitter;
    private closeEmitter;
    constructor();
    onError: Event<[Error, Message, number]>;
    protected fireError(error: any, message?: Message, count?: number): void;
    onClose: Event<void>;
    protected fireClose(): void;
    private asError(error);
}
export declare class StreamMessageWriter extends AbstractMessageWriter implements MessageWriter {
    private writable;
    private encoding;
    private errorCount;
    constructor(writable: NodeJS.WritableStream, encoding?: string);
    write(msg: Message): void;
}
export declare class IPCMessageWriter extends AbstractMessageWriter implements MessageWriter {
    private process;
    private errorCount;
    constructor(process: NodeJS.Process | ChildProcess);
    write(msg: Message): void;
}
