import { Message, RequestMessage, RequestType, ResponseError, ErrorCodes, NotificationMessage, NotificationType } from './messages';
import { MessageReader, DataCallback, StreamMessageReader, IPCMessageReader } from './messageReader';
import { MessageWriter, StreamMessageWriter, IPCMessageWriter } from './messageWriter';
import { Disposable, Event, Emitter } from './events';
import { CancellationTokenSource, CancellationToken } from './cancellation';
export { Message, ErrorCodes, ResponseError, RequestMessage, RequestType, NotificationMessage, NotificationType, MessageReader, DataCallback, StreamMessageReader, IPCMessageReader, MessageWriter, StreamMessageWriter, IPCMessageWriter, CancellationTokenSource, CancellationToken, Disposable, Event, Emitter };
export interface RequestHandler<P, R, E> {
    (params: P, token: CancellationToken): R | ResponseError<E> | Thenable<R | ResponseError<E>>;
}
export interface NotificationHandler<P> {
    (params: P): void;
}
export interface Logger {
    error(message: string): void;
    warn(message: string): void;
    info(message: string): void;
    log(message: string): void;
}
export declare enum Trace {
    Off = 0,
    Messages = 1,
    Verbose = 2,
}
export declare type TraceValues = 'off' | 'messages' | 'verbose';
export declare namespace Trace {
    function fromString(value: string): Trace;
    function toString(value: Trace): TraceValues;
}
export interface SetTraceParams {
    value: TraceValues;
}
export declare namespace SetTraceNotification {
    const type: NotificationType<SetTraceParams>;
}
export interface LogTraceParams {
    message: string;
    verbose?: string;
}
export declare namespace LogTraceNotification {
    const type: NotificationType<LogTraceParams>;
}
export interface Tracer {
    log(message: string, data?: string): void;
}
export interface MessageConnection {
    sendRequest<P, R, E>(type: RequestType<P, R, E>, params: P, token?: CancellationToken): Thenable<R>;
    onRequest<P, R, E>(type: RequestType<P, R, E>, handler: RequestHandler<P, R, E>): void;
    sendNotification<P>(type: NotificationType<P>, params?: P): void;
    onNotification<P>(type: NotificationType<P>, handler: NotificationHandler<P>): void;
    trace(value: Trace, tracer: Tracer, sendNotification?: boolean): void;
    onError: Event<[Error, Message, number]>;
    onClose: Event<void>;
    onUnhandledNotification: Event<NotificationMessage>;
    listen(): any;
    onDispose: Event<void>;
    dispose(): void;
}
export interface ServerMessageConnection extends MessageConnection {
}
export interface ClientMessageConnection extends MessageConnection {
}
export declare function createServerMessageConnection(reader: MessageReader, writer: MessageWriter, logger: Logger): ServerMessageConnection;
export declare function createServerMessageConnection(inputStream: NodeJS.ReadableStream, outputStream: NodeJS.WritableStream, logger: Logger): ServerMessageConnection;
export declare function createClientMessageConnection(reader: MessageReader, writer: MessageWriter, logger: Logger): ClientMessageConnection;
export declare function createClientMessageConnection(inputStream: NodeJS.ReadableStream, outputStream: NodeJS.WritableStream, logger: Logger): ClientMessageConnection;
