import * as code from 'vscode';
import * as proto from './protocol';
import ProtocolCompletionItem from './protocolCompletionItem';
export declare function asDiagnostics(diagnostics: proto.Diagnostic[]): code.Diagnostic[];
export declare function asDiagnostic(diagnostic: proto.Diagnostic): code.Diagnostic;
export declare function asRange(value: proto.Range): code.Range;
export declare function asPosition(value: proto.Position): code.Position;
export declare function asDiagnosticSeverity(value: number): code.DiagnosticSeverity;
export declare function asHover(hover: proto.Hover): code.Hover;
export declare function asCompletionResult(result: proto.CompletionItem[] | proto.CompletionList): code.CompletionItem[] | code.CompletionList;
export declare function asCompletionItem(item: proto.CompletionItem): ProtocolCompletionItem;
export declare function asTextEdit(edit: proto.TextEdit): code.TextEdit;
export declare function asTextEdits(items: proto.TextEdit[]): code.TextEdit[];
export declare function asSignatureHelp(item: proto.SignatureHelp): code.SignatureHelp;
export declare function asSignatureInformations(items: proto.SignatureInformation[]): code.SignatureInformation[];
export declare function asSignatureInformation(item: proto.SignatureInformation): code.SignatureInformation;
export declare function asParameterInformations(item: proto.ParameterInformation[]): code.ParameterInformation[];
export declare function asParameterInformation(item: proto.ParameterInformation): code.ParameterInformation;
export declare function asDefinitionResult(item: proto.Definition): code.Definition;
export declare function asLocation(item: proto.Location): code.Location;
export declare function asReferences(values: proto.Location[]): code.Location[];
export declare function asDocumentHighlights(values: proto.DocumentHighlight[]): code.DocumentHighlight[];
export declare function asDocumentHighlight(item: proto.DocumentHighlight): code.DocumentHighlight;
export declare function asDocumentHighlightKind(item: proto.DocumentHighlightKind): code.DocumentHighlightKind;
export declare function asSymbolInformations(values: proto.SymbolInformation[], uri?: code.Uri): code.SymbolInformation[];
export declare function asSymbolInformation(item: proto.SymbolInformation, uri?: code.Uri): code.SymbolInformation;
export declare function asCommand(item: proto.Command): code.Command;
export declare function asCommands(items: proto.Command[]): code.Command[];
export declare function asCodeLens(item: proto.CodeLens): code.CodeLens;
export declare function asCodeLenses(items: proto.CodeLens[]): code.CodeLens[];
export declare function asWorkspaceEdit(item: proto.WorkspaceEdit): code.WorkspaceEdit;
